﻿/*	VERSION:	1.0


USAGE:
	#include "functions/getListMouseIndex.as"
	var getListMouseIndex = make_getListMouseIndex( self );
	
	var listIndex = getListMouseIndex( list._ymouse );
	
	
DESCRIPTION: 
	Converts a list-relative vertical pixel coordinate into a list-item index.
*/
function make_getListMouseIndex( self ){
	#include "hitClip.as"
	
	// measure the border
	var topLeft = {x: 0, y: 0};
	measure();
	
	setTimeout(function(){
		measure();
	}, 34);
	
	function measure(){
		topLeft.x = self.rows[0]._x || 0;
		topLeft.y = self.rows[0]._y || 0;
		
		for(var i=0;i<self.rows.length; i++){
			topLeft.y = Math.min( topLeft.y,  self.rows[ i ]._y );
		}// for each: row
	}// measure()
	
	
	// figure out the currently hovered index
	function getListMouseIndex(){
		var hit = hitClip( {x:_root._xmouse,y:_root._ymouse}, self.mask_mc || self );		// using the mask prevents detecting scroll-bar clicks
		if( !hit )		return;
		
		return getListIndex( self._ymouse );
	};// getListMouseIndex()
	
	
	
	function getListIndex( yPix ){
		var yMouse_pix = yPix;
		yMouse_pix -= topLeft.y;														// add border
		yMouse_pix += (self.vPosition * self.rowHeight);		// add scrolling
		var index = Math.floor(yMouse_pix / self.rowHeight);
		
		// sanity checks
		if( index < 0 )								return undefined;
		if( index >= self.length )		return undefined;
		return index;
	};// getListIndex()
	
	
	return getListMouseIndex;
}// make_getListMouseIndex()